
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.BO
{
    public class School : PI.FM.N000.Base.BL.BO.Base
    {
        public School(Gemini.Core.BL.Interface.DBD.IDBDBase DBDBase)
            : base(DBDBase) { }

        #region Public members
        public string Name
        {
            get { return GetValue<string>("Name"); }
            set { SetValue<string>("Name", value); }
        }

        public string AddressLine1
        {
            get { return GetValue<string>("AddressLine1"); }
            set { SetValue<string>("AddressLine1", value); }
        }

        public string AddressLine2
        {
            get { return GetValue<string>("AddressLine2"); }
            set { SetValue<string>("AddressLine2", value); }
        }

        public string PostCode
        {
            get { return GetValue<string>("PostCode"); }
            set { SetValue<string>("PostCode", value); }
        }

        public string Town
        {
            get { return GetValue<string>("Town"); }
            set { SetValue<string>("Town", value); }
        }

        public string Tel
        {
            get { return GetValue<string>("Tel"); }
            set { SetValue<string>("Tel", value); }
        }

        public string Fax
        {
            get { return GetValue<string>("Fax"); }
            set { SetValue<string>("Fax", value); }
        }

        public string Email
        {
            get { return GetValue<string>("Email"); }
            set { SetValue<string>("Email", value); }
        }
        #endregion

        /// <summary>
        /// Zwraca szkole
        /// </summary>
        /// <returns></returns>
        internal BL.API.Model.GSchool GetApiObject()
        {
            return new API.Model.GSchool() { id = ID.ToString(), name = Name, city = Town };
        }

        internal void Assign(API.Model.GSchool School)
        {
            ID = long.Parse(School.id);
            Name = School.name;
            Town = School.city;
        }

        #region Search
        public new class Search : PI.FM.N000.Base.BL.BO.Base.Search
        {
            public string Name { get; set; }
            public string Town { get; set; }
            public string Address { get; set; }
        }
        #endregion

        public override string DisplayValue
        {
            get
            {
                return Name;
            }
        }
    }
}
